//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define SQLExportTempFile "C:\\SQLExp.txt"
#define FileBufferSize    512

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SendFileDataToServer(char *FileName)
{
    FILE *SourceHandle = NULL;

	if( (SourceHandle = fopen(FileName, "rb")) == NULL)
    {
        InsertListBoxItem(MDI.RecvEdit_hWnd, "Failed to open export file for binary read", -1);
        return false;
    }

    int BytesRead = 0;
    int ReceiveSize = 0;

    char *FileBuffer  = NULL;

    dlDataCRC = 0xffffffff;

    FileBuffer = (char *) calloc(FileBufferSize + 1, 1);

    MyClient.RawMode = true;

    do{
        if(MyClient.PeekSizeOfSendData() == 0)
        {
            BytesRead = fread(FileBuffer, sizeof(char), FileBufferSize, SourceHandle);
            dlDataCRC = PartialCRC(dlDataCRC, FileBuffer, BytesRead);
            ClientSend(FileBuffer, BytesRead);
        }
        else Sleep(1);
    } while(BytesRead == FileBufferSize && MyClient.Connected);


    // Wait for all data to be sent before switching from RawMode
    while(MyClient.PeekSizeOfSendData() != 0 && MyClient.Connected)
    {
        Sleep(1);
    }

    MyClient.RawMode = false;

    dlDataCRC = (dlDataCRC ^ 0xffffffff);

    free(FileBuffer);
    FileBuffer = NULL;

    if(SourceHandle) fclose(SourceHandle);
    SourceHandle = NULL;

    Sleep(1000);

    if(MyClient.Connected == false)
    {
        InsertListBoxItem(MDI.RecvEdit_hWnd, "Disconnected during file transfer.", -1);
        return false;
    }

    return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void GetSQLErrorMessage(void)
{
/*
    char ReturnChar[255];

    SQLCHAR     szSqlState[20];
    SQLINTEGER  ssErr;
    SQLCHAR     szErrorMsg [MAX_CONN_OUT];
    SQLSMALLINT cbErrorMsg;

    SQLError(henv, hdbc, SQL_NULL_HSTMT, szSqlState, &ssErr, szErrorMsg, MAX_CONN_OUT, &cbErrorMsg);
    ErrorMessage(NULL, (char *)szErrorMsg);
*/
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char gsImportTable[64];

int ProcessCommand(char *ReceivedData, int ReceivedSize)
{
    int FlagLength = 0;
    int FlaggedLength = 0;
    char FlaggedData[MaxReceiveSize + 1];

    if((FlagLength = CompareFlagedString(ReceivedData, "::ImportTable:")))
    {
    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';
        
        strcpy(gsImportTable, FlaggedData);
        return COMMAND_RESULT_OK;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::Statement:")))
    {
        char StatTemp[255];

    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        sprintf(StatTemp, "Exporting %s data.", gsImportTable);
        InsertListBoxItem(MDI.RecvEdit_hWnd, StatTemp, -1);

        if(!ExportSQLResults(gsSQLDriver, gsSQLServer, gsSQLUserID, gsSQLPassword, gsSQLDatabase, FlaggedData, gsImportTable, SQLExportTempFile))
        {
            InsertListBoxItem(MDI.RecvEdit_hWnd, "Failed to execute SQL statement:", -1);// FIXME: Need to log this error

            sprintf(StatTemp, "gsSQLDriver: %s", gsSQLDriver);
            InsertListBoxItem(MDI.RecvEdit_hWnd, StatTemp, -1);
            sprintf(StatTemp, "gsSQLServer: %s", gsSQLServer);
            InsertListBoxItem(MDI.RecvEdit_hWnd, StatTemp, -1);
            sprintf(StatTemp, "gsSQLUserID: %s", gsSQLUserID);
            InsertListBoxItem(MDI.RecvEdit_hWnd, StatTemp, -1);
            sprintf(StatTemp, "gsSQLPassword: %s", gsSQLPassword);
            InsertListBoxItem(MDI.RecvEdit_hWnd, StatTemp, -1);
            sprintf(StatTemp, "gsSQLDatabase: %s", gsSQLDatabase);
            InsertListBoxItem(MDI.RecvEdit_hWnd, StatTemp, -1);

            GetSQLErrorMessage();

            InsertListBoxItem(MDI.RecvEdit_hWnd, FlaggedData, -1);
        }
        else{
            sprintf(FlaggedData, "::FileSize:%d", Get_FileSize(SQLExportTempFile));
            SimpleClientSend(FlaggedData);

            sprintf(FlaggedData, "::FileName:%s", gsImportTable);
            SimpleClientSend(FlaggedData);

            Sleep(1000);

            SendFileDataToServer(SQLExportTempFile);
        }

        SimpleClientSend("::RequestNextStatement");
        return COMMAND_RESULT_OK;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::Error:")))
    {
    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        InsertListBoxItem(MDI.RecvEdit_hWnd, FlaggedData, -1);
        return COMMAND_RESULT_DISCONNECT;
    }
    else if(strcmp(ReceivedData, "::EndOfStatements") == 0)
    {
    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        InsertListBoxItem(MDI.RecvEdit_hWnd, "Done!", -1);
        return COMMAND_RESULT_DISCONNECT;
    }

    InsertListBoxItem(MDI.RecvEdit_hWnd, ReceivedData, -1);
	return COMMAND_RESULT_UNKNOWN;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

